#include <GUIConstantsEx.au3>
#include 'TCPInet.au3'

$sPath = @DesktopDir

$sURL1 = 'http://creator-lab.ucoz.ru/Testing_Zone/Opera_Dll.zip'
$sURL2 = 'http://svn2.assembla.com/svn/anthraxinteractive/encrpytion/emdll/au3src/src/AutoIt.cpp'

$hGUI = GUICreate('TCPInet.au3 Example', 300, 100)
GUICtrlCreateLabel(StringRegExp($sURL1, '([^/]+)$', 3)[0], 10, 20, 150, 20)
$iLabel1 = GUICtrlCreateLabel('', 180, 20, 100, 20)
GUICtrlCreateLabel(StringRegExp($sURL2, '([^/]+)$', 3)[0] & ' [MEMORY]', 10, 40, 150, 20)
$iLabel2 = GUICtrlCreateLabel('', 180, 40, 100, 20)
$iPause_Bttn = GUICtrlCreateButton('Pause', (300 / 2) - 35, 70, 70, 20)
GUISetState(@SW_SHOW, $hGUI)

$hInet1 = _TCPInet_GetFile($sURL1, $sPath, True, $TCPINET_DOWNLOADBACKGROUND)
$hInet2 = _TCPInet_GetFile($sURL2, '', False, $TCPINET_DOWNLOADBACKGROUND) ;Download to memory

$bMemory = Binary('')
$fCheckInfo = True

While 1
	$nMsg = GUIGetMsg()
	
	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			_TCPInet_Close($hInet1)
			_TCPInet_Close($hInet2)
			
			Exit
		Case $iPause_Bttn
			$iState = True
			$sText = 'Resume'
			
			If GUICtrlRead($iPause_Bttn) <> 'Pause' Then
				$iState = False
				$sText = 'Pause'
			EndIf
			
			GUICtrlSetData($iPause_Bttn, $sText)
			
			_TCPInet_Pause($hInet1, $iState)
			_TCPInet_Pause($hInet2, $iState)
	EndSwitch
	
	If $fCheckInfo Then
		If _TCPInet_GetInfo() > 0 Then
			_SetLabelProgress($hInet1, $iLabel1)
			_SetLabelProgress($hInet2, $iLabel2)
		Else
			$fCheckInfo = False
		EndIf
	EndIf
WEnd

Func _SetLabelProgress($hInet, $iLabel)
	Local $aInfo = _TCPInet_GetInfo($hInet, -1)
	Local $iError = @error
	
	If BinaryLen($aInfo[$TCPINET_DOWNLOADDATA]) Then
		$bMemory += $aInfo[$TCPINET_DOWNLOADDATA]
	EndIf
	
	If $iError Or $aInfo[$TCPINET_DOWNLOADCOMPLETE] Then
		If BinaryLen($bMemory) Then
			Local $hFile = FileOpen($sPath & '\' & StringRegExp($sURL2, '([^/]+)$', 3)[0], 2 + 16)
			FileWrite($hFile, $bMemory)
			FileClose($hFile)
			
			$bMemory = Binary('')
		EndIf
		
		Return
	EndIf
	
	Local $sProgress = Floor($aInfo[$TCPINET_DOWNLOADREAD] / $aInfo[$TCPINET_DOWNLOADSIZE] * 100) & '%'
	
	If GUICtrlRead($iLabel) <> $sProgress Then
		GUICtrlSetData($iLabel, $sProgress)
	EndIf
	
	If $sProgress = '100%' Then
		GUICtrlSetData($iLabel, 'Completed')
	EndIf
EndFunc
